document.getElementById("claudepanel").style.display = "none";

chrome.tabs.query({active: true, currentWindow: true}, async (tabs) => {
	chrome.tabs.sendMessage(tabs[0].id, {
	    messageType: "CHECK_CLAUDE",
	}, (response) => {
			if(response === undefined) {
					document.getElementById("claudeprompttype").remove();
					document.getElementsByTagName("br")[0].remove();
					// document.getElementsByTagName("br")[1].remove();
			}

			if(response.includes("claude.ai/")) {
					if(response.includes("chats")) {
						document.getElementById("chatgptpanel").style.display = "none";
						document.getElementById("claudepanel").style.display = "block";
						document.getElementsByTagName("h1")[0].innerText = "Atomic Gains: Prompt Assistant for Claude";
					} else if(!response.includes("chats")) {
						chrome.tabs.sendMessage(tabs[0].id, {
						    messageType: "PROCEED_TO_CLAUDE",
						}, (response) => {
								console.log(response);
								document.getElementById("chatgptpanel").style.display = "none";
								document.getElementById("claudepanel").style.display = "block";
								document.getElementsByTagName("h1")[0].innerText = "Atomic Gains: Prompt Assistant for Claude";
						});		
					}
			}
	});
});

document.getElementById("claudeprompttype").onchange = async function() {
		document.getElementById("claudepanel").innerHTML = "Loading components...";
		if(document.getElementById("claudeprompttype").value == "Public") {
				var publicPromptsData = await getPublicPrompts();
				var dynamicClaudeHTMLs = "";
				for(var io = 0; io < publicPromptsData.data.length; io++) {
						dynamicClaudeHTMLs += "<button class='claudebutton' id='prompt-"+publicPromptsData.data[io].id+"'><h3>"+publicPromptsData.data[io].title+"</h3><p>"+publicPromptsData.data[io].teaser+"</p><small>"+publicPromptsData.data[io].type+" / "+publicPromptsData.data[io].authorname+"</small></button><br><br>";
				}
				document.getElementById("claudepanel").innerHTML = dynamicClaudeHTMLs;
				var claudebutton = document.getElementsByClassName("claudebutton");
				for(var cb = 0; cb < claudebutton.length; cb++) {
						(function(index) {
		              claudebutton[index].addEventListener("click", function(event) {
		                  chrome.tabs.query({active: true, currentWindow: true}, async (tabs) => {
											chrome.tabs.sendMessage(tabs[0].id, {
											    messageType: "EXECUTE_PROMPTS",
											    promptId: claudebutton[index].getAttribute("id")
											}, (response) => {
													console.log(response);
													window.close();
											});
										});
		              });
		          })(cb);
				}
		} else if(document.getElementById("claudeprompttype").value == "Own") {
				var publicPromptsData = await getOwnedPrompts();
				var dynamicClaudeHTMLs = "";
				for(var io = 0; io < publicPromptsData.data.length; io++) {
						dynamicClaudeHTMLs += "<button class='claudebutton' id='prompt-"+publicPromptsData.data[io].id+"'><h3>"+publicPromptsData.data[io].title+"</h3><p>"+publicPromptsData.data[io].teaser+"</p><small>"+publicPromptsData.data[io].type+" / "+publicPromptsData.data[io].authorname+"</small></button><br><br>";
				}
				document.getElementById("claudepanel").innerHTML = dynamicClaudeHTMLs;
				var claudebutton = document.getElementsByClassName("claudebutton");
				for(var cb = 0; cb < claudebutton.length; cb++) {
						(function(index) {
		              claudebutton[index].addEventListener("click", function(event) {
		                  chrome.tabs.query({active: true, currentWindow: true}, async (tabs) => {
											chrome.tabs.sendMessage(tabs[0].id, {
											    messageType: "EXECUTE_PROMPTS",
											    promptId: claudebutton[index].getAttribute("id")
											}, (response) => {
													console.log(response);
													window.close();
											});
										});
		              });
		          })(cb);
				}
		}
		
}

// const firebaseConfig = {
//   apiKey: "AIzaSyAS4QspRKmmYEMoRDWtTcXg-qyORY_APVE",
//   authDomain: "digi-prompts.firebaseapp.com",
//   projectId: "digi-prompts",
//   storageBucket: "digi-prompts.appspot.com",
//   messagingSenderId: "1063376835322",
//   appId: "1:1063376835322:web:53179fd355c36c6a78af43",
//   measurementId: "G-LH43WQC7WP"
// };

// firebase.initializeApp(firebaseConfig);
// let cloudDB = firebase.firestore();

var apiLink = "https://unicacloud.me/atomicgainsextension/data.php";

chrome.storage.local.get(["digipromptsemail", "currentUrl", "digipromptsnewslettersubscribed"], async function(result) {

	document.getElementById("useremailfromchrome").value = result.digipromptsemail;
	/*if(!result.currentUrl.includes("chat.openai.com")) {
		document.body.innerHTML = "<h1>This extension is not available on this webpage. Go the chat.openai.com then reopen this popup.</h1>";
	}*/

	// chrome.runtime.sendMessage({ message: 'GET_ALL_TEMPLATE' }, function (response) {
	//     console.log(response); // This will log the response from the background script
	// });

	// chrome.runtime.sendMessage({ message: 'GET_ALL_FILTERED_WORDS', email: result.digipromptsemail }, function (response) {
	//     console.log(response); // This will log the response from the background script
	// });

});

setTimeout( async function() {
		var dynamicClaudeHTMLs = "";
		if(document.getElementById("claudepanel").style.display == "block") {
				var publicPromptsData = await getPublicPrompts();
				for(var io = 0; io < publicPromptsData.data.length; io++) {
						dynamicClaudeHTMLs += "<button class='claudebutton' id='prompt-"+publicPromptsData.data[io].id+"'><h3>"+publicPromptsData.data[io].title+"</h3><p>"+publicPromptsData.data[io].teaser+"</p><small>"+publicPromptsData.data[io].type+" / "+publicPromptsData.data[io].authorname+"</small></button><br><br>";
				}
				document.getElementById("claudepanel").innerHTML = dynamicClaudeHTMLs;
				var claudebutton = document.getElementsByClassName("claudebutton");
				for(var cb = 0; cb < claudebutton.length; cb++) {
						(function(index) {
                claudebutton[index].addEventListener("click", function(event) {
                    chrome.tabs.query({active: true, currentWindow: true}, async (tabs) => {
											chrome.tabs.sendMessage(tabs[0].id, {
											    messageType: "EXECUTE_PROMPTS",
											    promptId: claudebutton[index].getAttribute("id")
											}, (response) => {
													console.log(response);
													window.close();
											});
										});
                });
            })(cb);
				}
		}
}, 3000);

// chrome.runtime.sendMessage({ message: 'GET_ALL_TEMPLATE' }, function (response) {
//     console.log(response); // This will log the response from the background script
// });

// chrome.runtime.sendMessage({ message: 'GET_ALL_TEMPLATE' }, function (response) {
//     console.log(response); // This will log the response from the background script
// });

// chrome.runtime.sendMessage({ message: 'GET_ALL_TEMPLATE' }, function (response) {
//     console.log(response); // This will log the response from the background script
// });

var useremailfromchrome = document.getElementById("useremailfromchrome").value;

	async function getPublicPrompts() {
	    try {
	        const response = await fetch(apiLink + '?action=get_public_prompts');
	        if (!response.ok) {
	            throw new Error('Network response was not ok');
	        }
	        return await response.json(); // Return the processed data
	    } catch (error) {
	        console.error('Fetch operation failed:', error);
	    }
	}

	async function getOwnedPrompts() {
	    try {
	        const response = await fetch(apiLink + '?action=get_owned_prompts&email='+document.getElementById("useremailfromchrome").value);
	        if (!response.ok) {
	            throw new Error('Network response was not ok');
	        }
	        return await response.json(); // Return the processed data
	    } catch (error) {
	        console.error('Fetch operation failed:', error);
	    }
	}

	async function getToEditPrompts() {
	    try {
	        const response = await fetch(apiLink + '?action=get_to_edit_prompts&email='+document.getElementById("useremailfromchrome").value);
	        if (!response.ok) {
	            throw new Error('Network response was not ok');
	        }
	        return await response.json(); // Return the processed data
	    } catch (error) {
	        console.error('Fetch operation failed:', error);
	    }
	}

	async function getGroups() {
	    try {
	        const response = await fetch(apiLink + '?action=get_all_groups');
	        if (!response.ok) {
	            throw new Error('Network response was not ok');
	        }
	        return await response.json(); // Return the processed data
	    } catch (error) {
	        console.error('Fetch operation failed:', error);
	    }
	}

	async function getSinglePrompt(template_id) {
	    try {
	        const response = await fetch(apiLink + '?action=get_single_prompt&id='+template_id);
	        if (!response.ok) {
	            throw new Error('Network response was not ok');
	        }
	        return await response.json(); // Return the processed data
	    } catch (error) {
	        console.error('Fetch operation failed:', error);
	    }
	}

	async function getTopics() {
      try {
          const response = await fetch(apiLink + '?action=get_topics');
          if (!response.ok) {
              throw new Error('Network response was not ok');
          }
          return await response.json(); // Return the processed data
      } catch (error) {
          console.error('Fetch operation failed:', error);
      }
  }

  async function getActivities() {
      try {
          const response = await fetch(apiLink + '?action=get_activities');
          if (!response.ok) {
              throw new Error('Network response was not ok');
          }
          return await response.json(); // Return the processed data
      } catch (error) {
          console.error('Fetch operation failed:', error);
      }
  }

  async function getUsers() {
      try {
          const response = await fetch(apiLink + '?action=get_all_users');
          if (!response.ok) {
              throw new Error('Network response was not ok');
          }
          return await response.json(); // Return the processed data
      } catch (error) {
          console.error('Fetch operation failed:', error);
      }
  }

  async function getSingleUser(useremailfromchrome) {
      try {
          const response = await fetch(apiLink + '?action=get_single_user&email='+useremailfromchrome);
          if (!response.ok) {
              throw new Error('Network response was not ok');
          }
          return await response.json(); // Return the processed data
      } catch (error) {
          console.error('Fetch operation failed:', error);
      }
  }

	async function getFilteredWords() {
	    try {
	        const response = await fetch(apiLink + '?action=get_filtered_words');
	        if (!response.ok) {
	            throw new Error('Network response was not ok');
	        }
	        return await response.json(); // Return the processed data
	    } catch (error) {
	        console.error('Fetch operation failed:', error);
	    }
	}

	async function checkGroupShareExistBeforeSaving(group_id, template_id) {
	    try {
	        const response = await fetch(apiLink + '?action=check_group_share_exist_before_saving&group='+group_id+'&template='+template_id);
	        if (!response.ok) {
	            throw new Error('Network response was not ok');
	        }
	        return await response.json(); // Return the processed data
	    } catch (error) {
	        console.error('Fetch operation failed:', error);
	    }
	}

	async function chechIndividualShareExistBeforeSaving(email, template_id) {
	    try {
	        const response = await fetch(apiLink + '?action=check_individual_share_exist_before_saving&email='+email+'&template='+template_id);
	        if (!response.ok) {
	            throw new Error('Network response was not ok');
	        }
	        return await response.json(); // Return the processed data
	    } catch (error) {
	        console.error('Fetch operation failed:', error);
	    }
	}

	async function saveTopic(data) {
	    try {
	        const response = await fetch(apiLink + '?action=save_topic', {
	            method: 'POST',
	            headers: {
	                'Content-Type': 'application/json',
	            },
	            body: JSON.stringify(data),
	        });
	        if (!response.ok) {
	            throw new Error('Network response was not ok');
	        }
	        return await response.json();
	    } catch (error) {
	        console.error('Fetch operation failed:', error);
	    }
	}

	async function deleteTopic(data) {
	    try {
	        const response = await fetch(apiLink + '?action=delete_topic', {
	            method: 'POST',
	            headers: {
	                'Content-Type': 'application/json',
	            },
	            body: JSON.stringify(data),
	        });
	        if (!response.ok) {
	            throw new Error('Network response was not ok');
	        }
	        return await response.json();
	    } catch (error) {
	        console.error('Fetch operation failed:', error);
	    }
	}

	async function checkExistingTopics(data) {
      try {
	        const response = await fetch(apiLink + '?action=check_topic', {
	            method: 'POST',
	            headers: {
	                'Content-Type': 'application/json',
	            },
	            body: JSON.stringify(data),
	        });
	        if (!response.ok) {
	            throw new Error('Network response was not ok');
	        }
	        return await response.json();
	    } catch (error) {
	        console.error('Fetch operation failed:', error);
	    }
  }

  async function saveActivity(data) {
	    try {
	        const response = await fetch(apiLink + '?action=save_activity', {
	            method: 'POST',
	            headers: {
	                'Content-Type': 'application/json',
	            },
	            body: JSON.stringify(data),
	        });
	        if (!response.ok) {
	            throw new Error('Network response was not ok');
	        }
	        return await response.json();
	    } catch (error) {
	        console.error('Fetch operation failed:', error);
	    }
	}

	async function deleteActivity(data) {
	    try {
	        const response = await fetch(apiLink + '?action=delete_activity', {
	            method: 'POST',
	            headers: {
	                'Content-Type': 'application/json',
	            },
	            body: JSON.stringify(data),
	        });
	        if (!response.ok) {
	            throw new Error('Network response was not ok');
	        }
	        return await response.json();
	    } catch (error) {
	        console.error('Fetch operation failed:', error);
	    }
	}

	async function checkExistingActivities(data) {
      try {
	        const response = await fetch(apiLink + '?action=check_activity', {
	            method: 'POST',
	            headers: {
	                'Content-Type': 'application/json',
	            },
	            body: JSON.stringify(data),
	        });
	        if (!response.ok) {
	            throw new Error('Network response was not ok');
	        }
	        return await response.json();
	    } catch (error) {
	        console.error('Fetch operation failed:', error);
	    }
  }

  async function saveUser(data) {
	    try {
	        const response = await fetch(apiLink + '?action=save_user', {
	            method: 'POST',
	            headers: {
	                'Content-Type': 'application/json',
	            },
	            body: JSON.stringify(data),
	        });
	        if (!response.ok) {
	            throw new Error('Network response was not ok');
	        }
	        return await response.json();
	    } catch (error) {
	        console.error('Fetch operation failed:', error);
	    }
	}

	async function deleteUser(data) {
	    try {
	        const response = await fetch(apiLink + '?action=delete_user', {
	            method: 'POST',
	            headers: {
	                'Content-Type': 'application/json',
	            },
	            body: JSON.stringify(data),
	        });
	        if (!response.ok) {
	            throw new Error('Network response was not ok');
	        }
	        return await response.json();
	    } catch (error) {
	        console.error('Fetch operation failed:', error);
	    }
	}

	async function pauseUser(data) {
	    try {
	        const response = await fetch(apiLink + '?action=pause_user', {
	            method: 'POST',
	            headers: {
	                'Content-Type': 'application/json',
	            },
	            body: JSON.stringify(data),
	        });
	        if (!response.ok) {
	            throw new Error('Network response was not ok');
	        }
	        return await response.json();
	    } catch (error) {
	        console.error('Fetch operation failed:', error);
	    }
	}

	async function activateUser(data) {
	    try {
	        const response = await fetch(apiLink + '?action=activate_user', {
	            method: 'POST',
	            headers: {
	                'Content-Type': 'application/json',
	            },
	            body: JSON.stringify(data),
	        });
	        if (!response.ok) {
	            throw new Error('Network response was not ok');
	        }
	        return await response.json();
	    } catch (error) {
	        console.error('Fetch operation failed:', error);
	    }
	}

	async function saveGroup(data) {
	    try {
	        const response = await fetch(apiLink + '?action=save_group', {
	            method: 'POST',
	            headers: {
	                'Content-Type': 'application/json',
	            },
	            body: JSON.stringify(data),
	        });
	        if (!response.ok) {
	            throw new Error('Network response was not ok');
	        }
	        return await response.json();
	    } catch (error) {
	        console.error('Fetch operation failed:', error);
	    }
	}

	async function saveGroupMember(data) {
	    try {
	        const response = await fetch(apiLink + '?action=save_groupmember', {
	            method: 'POST',
	            headers: {
	                'Content-Type': 'application/json',
	            },
	            body: JSON.stringify(data),
	        });
	        if (!response.ok) {
	            throw new Error('Network response was not ok');
	        }
	        return await response.json();
	    } catch (error) {
	        console.error('Fetch operation failed:', error);
	    }
	}

	async function savePrompt(data) {
			try {
	        const response = await fetch(apiLink + '?action=add_prompt', {
	            method: 'POST',
	            headers: {
	                'Content-Type': 'application/json',
	            },
	            body: JSON.stringify(data),
	        });
	        if (!response.ok) {
	            throw new Error('Network response was not ok'); 
	        }
	        console.log(response);
	        return await response;
	    } catch (error) {
	        console.error('Fetch operation failed:', error);
	    }
	}

	async function updatePrompt(data) {
			try {
	        const response = await fetch(apiLink + '?action=update_prompt', {
	            method: 'POST',
	            headers: {
	                'Content-Type': 'application/json',
	            },
	            body: JSON.stringify(data),
	        });
	        if (!response.ok) {
	            throw new Error('Network response was not ok');
	        }
	        return await response.json();
	    } catch (error) {
	        console.error('Fetch operation failed:', error);
	    }
	}

document.getElementById("filteredwordssettings").style.display = "none";
document.getElementById("sharetemplatetogroup").style.display = "none";
document.getElementById("sharetemplatetoindividual").style.display = "none";
document.getElementById("addnewgroup").style.display = "none";
document.getElementById("adddeletetopic").style.display = "none";
document.getElementById("adddeleteactivity").style.display = "none";
document.getElementById("addnewprompt").style.display = "none";
document.getElementById("manageusers").style.display = "none";
document.getElementById("editnewprompt").style.display = "none";

document.getElementById("newInstructionSelect").onchange = function() {
	if(document.getElementById("newInstructionSelect").value != "") {
		if(document.getElementById("newInstructionSelect").value == "Text") {
			document.getElementById("newInstruction").setAttribute("placeholder", "Type the user instuction for this template in text.");
		} else if(document.getElementById("newInstructionSelect").value == "Video") {
			document.getElementById("newInstruction").setAttribute("placeholder", "Paste the video URL of the video instruction.");
		}
	}
}

document.getElementById("editInstructionSelect").onchange = function() {
	if(document.getElementById("editInstructionSelect").value != "") {
		if(document.getElementById("editInstructionSelect").value == "Text") {
			document.getElementById("editInstruction").setAttribute("placeholder", "Type the user instuction for this template in text.");
		} else if(document.getElementById("editInstructionSelect").value == "Video") {
			document.getElementById("editInstruction").setAttribute("placeholder", "Paste the video URL of the video instruction.");
		}
	}
}

document.getElementById("newPromptType").onchange = function() {
	localStorage.setItem("digiprompts_newprompttype", document.getElementById("newPromptType").value);
	if(document.getElementById("newPromptType").value == "Regular") {
		document.getElementById("newPrompt").placeholder = "Enter the prompt details here.";
		document.getElementById("newPromptHint").placeholder = "Enter 2 or more hints here, separated by \[\=\]. Don't need to add colon (:) on hint";
		document.getElementById("newPrompt").style.display = "block";
		document.getElementById("newPromptSeparateMultiRandom").style.display = "none";
	} else if(document.getElementById("newPromptType").value == "Multivariate Alchemy") {
		document.getElementById("newPrompt").placeholder = "Enter 2 or more prompt details here separated by.\[\=\]";
		document.getElementById("newPromptHint").placeholder = "Enter 2 or more hints here, separated by \[\=\]. Don't need to add colon (:) on hint";
		document.getElementById("newPrompt").style.display = "none";
		document.getElementById("newPromptSeparateMultiRandom").style.display = "block";
	} else if(document.getElementById("newPromptType").value == "Multi-step") {
		document.getElementById("newPrompt").placeholder = "Write 2 or more different prompts in iterating steps. Put \[\=\] to separate different question steps.";
		document.getElementById("newPromptHint").placeholder = "Enter 2 or more hints here, separated by \[\=\]. Don't need to add colon (:) on hint";
		document.getElementById("newPrompt").style.display = "block";
		document.getElementById("newPromptSeparateMultiRandom").style.display = "none";
	}
}

document.getElementById("settingselect").onchange = async function() {
	document.getElementById("imageloader2").style.display = "inline-block";  

	// const promptsCollection = cloudDB.collection('prompts');
	// const promptsData = await promptsCollection.where('Publicity', '==', "Own").where('AuthorEmail', '==', useremailfromchrome.trim()).get().then(snapshot => {
	//   return snapshot.docs.map(doc => {
	//     return {
	// 	      id: doc.id,
	// 	      data: doc.data()
	//     };
	//   });
	// });

	// const promptsToEditCollection = cloudDB.collection('prompts');
	// const promptsToEditData = await promptsToEditCollection.where('AuthorEmail', '==', useremailfromchrome.trim()).get().then(snapshot => {
	//   return snapshot.docs.map(doc => {
	//     return {
	// 	      id: doc.id,
	// 	      data: doc.data()
	//     };
	//   });
	// });

	// const groupsCollection = cloudDB.collection('groups');
	// const groupsData = await groupsCollection.where('createdby', '==', useremailfromchrome.trim()).get().then(snapshot => {
	//   return snapshot.docs.map(doc => {
	//     return {
	// 	      id: doc.id,
	// 	      data: doc.data()
	//     };
	//   });
	// });

	// const topicsCollection = cloudDB.collection('topics');
	// const topicsData = await topicsCollection.get().then(snapshot => {
	//   return snapshot.docs.map(doc => {
	//     return {
	// 	      id: doc.id,
	// 	      data: doc.data()
	//     };
	//   });
	// });

	// const activitiesCollection = cloudDB.collection('activities');
	// const activitiesData = await activitiesCollection.get().then(snapshot => {
	//   return snapshot.docs.map(doc => {
	//     return {
	// 	      id: doc.id,
	// 	      data: doc.data()
	//     };
	//   });
	// });

	// const usersCollection = cloudDB.collection('users');
	// const usersData = await usersCollection.get().then(snapshot => {
	//   return snapshot.docs.map(doc => {
	//     return {
	// 	      id: doc.id,
	// 	      data: doc.data()
	//     };
	//   });
	// });


	if(document.getElementById("settingselect").value == "General") {

		document.getElementById("generalsettings").style.display = "block";
		document.getElementById("filteredwordssettings").style.display = "none";
		document.getElementById("sharetemplatetogroup").style.display = "none";
		document.getElementById("sharetemplatetoindividual").style.display = "none";
		document.getElementById("addnewgroup").style.display = "none";
		document.getElementById("adddeletetopic").style.display = "none";
		document.getElementById("adddeleteactivity").style.display = "none";
		document.getElementById("addnewprompt").style.display = "none";
		document.getElementById("manageusers").style.display = "none";
		document.getElementById("editnewprompt").style.display = "none";

		document.getElementById("imageloader2").style.display = "none";

	} else if(document.getElementById("settingselect").value == "Change Password") {

		window.open("chrome-extension://"+chrome.runtime.id+"/changepassword.html", "_blank");

	} else if(document.getElementById("settingselect").value == "Filtered Words") {

		document.getElementById("generalsettings").style.display = "none";
		document.getElementById("filteredwordssettings").style.display = "block";
		document.getElementById("sharetemplatetogroup").style.display = "none";
		document.getElementById("sharetemplatetoindividual").style.display = "none";
		document.getElementById("addnewgroup").style.display = "none";
		document.getElementById("adddeletetopic").style.display = "none";
		document.getElementById("adddeleteactivity").style.display = "none";
		document.getElementById("addnewprompt").style.display = "none";
		document.getElementById("manageusers").style.display = "none";
		document.getElementById("editnewprompt").style.display = "none";

		document.getElementById("imageloader2").style.display = "none";

	} else if(document.getElementById("settingselect").value == "Share Template To Group") {

		document.getElementById("generalsettings").style.display = "none";
		document.getElementById("filteredwordssettings").style.display = "none";
		document.getElementById("sharetemplatetogroup").style.display = "block";
		document.getElementById("sharetemplatetoindividual").style.display = "none";
		document.getElementById("addnewgroup").style.display = "none";
		document.getElementById("adddeletetopic").style.display = "none";
		document.getElementById("adddeleteactivity").style.display = "none";
		document.getElementById("addnewprompt").style.display = "none";
		document.getElementById("manageusers").style.display = "none";
		document.getElementById("editnewprompt").style.display = "none";

		var promptsData = await getOwnedPrompts();
		var groupsData = await getGroups();

		var promptsOptionContent = "";
		promptsOptionContent += "<option value=''>Select prompt template</option>";
		for(var sg = 0; sg < promptsData.data.length; sg++) {
			promptsOptionContent += "<option value=" + promptsData.data[sg].id + ">" + promptsData.data[sg].title + "</option>";
		}
		document.getElementById("sharetogrouptemplates").innerHTML = promptsOptionContent;

		var groupsOptionContent = "";
		groupsOptionContent += "<option value=''>Select group</option>";
		for(var g = 0; g < groupsData.data.length; g++) {
			groupsOptionContent += "<option value=" + groupsData.data[g].id + ">" + groupsData.data[g].groupname + "</option>";
		}
		document.getElementById("grouplist").innerHTML = groupsOptionContent;

		document.getElementById("imageloader2").style.display = "none";

	} else if(document.getElementById("settingselect").value == "Share Template To Individual") {
		
		document.getElementById("generalsettings").style.display = "none";
		document.getElementById("filteredwordssettings").style.display = "none";
		document.getElementById("sharetemplatetogroup").style.display = "none";
		document.getElementById("sharetemplatetoindividual").style.display = "block";
		document.getElementById("addnewgroup").style.display = "none";
		document.getElementById("adddeletetopic").style.display = "none";
		document.getElementById("adddeleteactivity").style.display = "none";
		document.getElementById("addnewprompt").style.display = "none";
		document.getElementById("manageusers").style.display = "none";
		document.getElementById("editnewprompt").style.display = "none";

		var promptsData = await getOwnedPrompts();

		var promptsOptionContent = "";
		promptsOptionContent += "<option value=''>Select prompt template</option>";
		for(var sg = 0; sg < promptsData.data.length; sg++) {
			promptsOptionContent += "<option value=" + promptsData.data[sg].id + ">" + promptsData.data[sg].title + "</option>";
		}
		document.getElementById("sharetoindividualtemplates").innerHTML = promptsOptionContent;

		document.getElementById("imageloader2").style.display = "none";

	} else if(document.getElementById("settingselect").value == "Create New Group") {
		
		document.getElementById("generalsettings").style.display = "none";
		document.getElementById("filteredwordssettings").style.display = "none";
		document.getElementById("sharetemplatetogroup").style.display = "none";
		document.getElementById("sharetemplatetoindividual").style.display = "none";
		document.getElementById("addnewgroup").style.display = "block";
		document.getElementById("adddeletetopic").style.display = "none";
		document.getElementById("adddeleteactivity").style.display = "none";
		document.getElementById("addnewprompt").style.display = "none";
		document.getElementById("manageusers").style.display = "none";
		document.getElementById("editnewprompt").style.display = "none";

		document.getElementById("imageloader2").style.display = "none";

	} else if(document.getElementById("settingselect").value == "Manage Topics") {
		
		document.getElementById("generalsettings").style.display = "none";
		document.getElementById("filteredwordssettings").style.display = "none";
		document.getElementById("sharetemplatetogroup").style.display = "none";
		document.getElementById("sharetemplatetoindividual").style.display = "none";
		document.getElementById("addnewgroup").style.display = "none";
		document.getElementById("adddeletetopic").style.display = "block";
		document.getElementById("adddeleteactivity").style.display = "none";
		document.getElementById("addnewprompt").style.display = "none";
		document.getElementById("manageusers").style.display = "none";
		document.getElementById("editnewprompt").style.display = "none";

		var topicsData = await getTopics();

		var topicsContent = "";
		for(var t = 0; t < topicsData.data.length; t++) {
			topicsContent += "<tr><td><input type='checkbox' class='topiccheckboxes' value='" + topicsData.data[t].id + "'></td><td>" + topicsData.data[t].topic + "</td></tr>";
		}
		document.getElementById("topiclistTbody").innerHTML = topicsContent;

		document.getElementById("imageloader2").style.display = "none";

	} else if(document.getElementById("settingselect").value == "Manage Activities") {
		
		document.getElementById("generalsettings").style.display = "none";
		document.getElementById("filteredwordssettings").style.display = "none";
		document.getElementById("sharetemplatetogroup").style.display = "none";
		document.getElementById("sharetemplatetoindividual").style.display = "none";
		document.getElementById("addnewgroup").style.display = "none";
		document.getElementById("adddeletetopic").style.display = "none";
		document.getElementById("adddeleteactivity").style.display = "block";
		document.getElementById("addnewprompt").style.display = "none";
		document.getElementById("manageusers").style.display = "none";
		document.getElementById("editnewprompt").style.display = "none";

		var topicsData = await getTopics();
		var activityTopicSelects = "";
		for(var t = 0; t < topicsData.data.length; t++) {
			activityTopicSelects += "<option value='"+topicsData.data[t].topic+"'>"+topicsData.data[t].topic+"</option>";
		}
		document.getElementById("activitytopic").innerHTML = activityTopicSelects;

		var activitiesData = await getActivities();

		var activitiesContent = "";
		for(var a = 0; a < activitiesData.data.length; a++) {
			activitiesContent += "<tr><td><input type='checkbox' class='activitycheckboxes' value='" + activitiesData.data[a].id + "'></td><td>" + activitiesData.data[a].activity + "</td></tr>";
		}
		document.getElementById("activitylistTbody").innerHTML = activitiesContent;

		document.getElementById("imageloader2").style.display = "none";

	} else if(document.getElementById("settingselect").value == "Create New Template") {

		if(localStorage.getItem("digiprompts_newtitle") !== null) {
			document.getElementById("newTitle").value = localStorage.getItem("digiprompts_newtitle");
		}

		if(localStorage.getItem("digiprompts_newteaser") !== null) {
			document.getElementById("newTeaser").value = localStorage.getItem("digiprompts_newteaser");
		}

		if(localStorage.getItem("digiprompts_newprompttype") !== null) {
			document.getElementById("newPromptType").value = localStorage.getItem("digiprompts_newprompttype");
			if(localStorage.getItem("digiprompts_newprompttype") == "Multivariate Alchemy") {
				document.getElementById("newPromptSeparateMultiRandom").style.display = "block";
				document.getElementById("newPrompt").style.display = "none";
			} else {
				document.getElementById("newPrompt").style.display = "block";
				document.getElementById("newPromptSeparateMultiRandom").style.display = "none";
			}
		}

		if(localStorage.getItem("digiprompts_newprompt") !== null) {
			document.getElementById("newPrompt").value = localStorage.getItem("digiprompts_newprompt");
		}

		if(localStorage.getItem("digiprompts_newpromptmultirandom1") !== null) {
			document.getElementsByClassName("newPromptMultiRandom")[0].value = localStorage.getItem("digiprompts_newpromptmultirandom1");
		}

		if(localStorage.getItem("digiprompts_newpromptmultirandom2") !== null) {
			document.getElementsByClassName("newPromptMultiRandom")[1].value = localStorage.getItem("digiprompts_newpromptmultirandom2");
		}

		if(localStorage.getItem("digiprompts_newpromptmultirandom3") !== null) {
			document.getElementsByClassName("newPromptMultiRandom")[2].value = localStorage.getItem("digiprompts_newpromptmultirandom3");
		}

		if(localStorage.getItem("digiprompts_newpromptmultirandom4") !== null) {
			document.getElementsByClassName("newPromptMultiRandom")[3].value = localStorage.getItem("digiprompts_newpromptmultirandom4");
		}

		if(localStorage.getItem("digiprompts_newpromptmultirandom5") !== null) {
			document.getElementsByClassName("newPromptMultiRandom")[4].value = localStorage.getItem("digiprompts_newpromptmultirandom5");
		}

		if(localStorage.getItem("digiprompts_newpromptmultirandom6") !== null) {
			document.getElementsByClassName("newPromptMultiRandom")[5].value = localStorage.getItem("digiprompts_newpromptmultirandom6");
		}

		if(localStorage.getItem("digiprompts_newpromptmultirandom7") !== null) {
			document.getElementsByClassName("newPromptMultiRandom")[6].value = localStorage.getItem("digiprompts_newpromptmultirandom7");
		}

		if(localStorage.getItem("digiprompts_newpromptmultirandom8") !== null) {
			document.getElementsByClassName("newPromptMultiRandom")[7].value = localStorage.getItem("digiprompts_newpromptmultirandom8");
		}

		if(localStorage.getItem("digiprompts_newpromptmultirandom9") !== null) {
			document.getElementsByClassName("newPromptMultiRandom")[8].value = localStorage.getItem("digiprompts_newpromptmultirandom9");
		}

		if(localStorage.getItem("digiprompts_newpromptmultirandom10") !== null) {
			document.getElementsByClassName("newPromptMultiRandom")[9].value = localStorage.getItem("digiprompts_newpromptmultirandom10");
		}

		if(localStorage.getItem("digiprompts_newprompthint") !== null) {
			document.getElementById("newPromptHint").value = localStorage.getItem("digiprompts_newprompthint");
		}

		if(localStorage.getItem("digiprompts_newauthorname") !== null) {
			document.getElementById("newAuthorName").value = localStorage.getItem("digiprompts_newauthorname");
		}

		if(localStorage.getItem("digiprompts_newauthorurl") !== null) {
			document.getElementById("newAuthorURL").value = localStorage.getItem("digiprompts_newauthorurl");
		}

		if(localStorage.getItem("digiprompts_newpublicityselect") !== null) {
			document.getElementById("newPublicitySelect").value = localStorage.getItem("digiprompts_newpublicityselect");
		}

		if(localStorage.getItem("digiprompts_newtopicselect") !== null) {
			document.getElementById("newTopicSelect").value = localStorage.getItem("digiprompts_newtopicselect");
		}

		if(localStorage.getItem("digiprompts_newactivityselect") !== null) {
			document.getElementById("newActivitySelect").value = localStorage.getItem("digiprompts_newactivityselect");
		}

		if(localStorage.getItem("digiprompts_newinstructionselect") !== null) {
			document.getElementById("newInstructionSelect").value = localStorage.getItem("digiprompts_newinstructionselect");
		}

		if(localStorage.getItem("digiprompts_newinstruction") !== null) {
			document.getElementById("newInstruction").value = localStorage.getItem("digiprompts_newinstruction");
		}

		if(localStorage.getItem("digiprompts_newsocialwebsite") !== null) {
			document.getElementById("newSocialWebsite").value = localStorage.getItem("digiprompts_newsocialwebsite");
		}

		document.getElementById("generalsettings").style.display = "none";
		document.getElementById("filteredwordssettings").style.display = "none";
		document.getElementById("sharetemplatetogroup").style.display = "none";
		document.getElementById("sharetemplatetoindividual").style.display = "none";
		document.getElementById("addnewgroup").style.display = "none";
		document.getElementById("adddeletetopic").style.display = "none";
		document.getElementById("adddeleteactivity").style.display = "none";
		document.getElementById("addnewprompt").style.display = "block";
		document.getElementById("manageusers").style.display = "none";
		document.getElementById("editnewprompt").style.display = "none";

		var topicsData = await getTopics();
		var activitiesData = await getActivities();

		var topicsContent = "";
		document.getElementById("newTopicSelect").innerHTML = "";
		topicsContent += "<option value=''>Select topic</option>";
		for(var t = 0; t < topicsData.data.length; t++) {
			topicsContent += "<option value='" + topicsData.data[t].topic + "'>" + topicsData.data[t].topic + "</option>";
		}
		document.getElementById("newTopicSelect").innerHTML = topicsContent;

		var activitiesContent = "";
		document.getElementById("newActivitySelect").innerHTML = "";
		activitiesContent += "<option value=''>Select activity</option>";
		for(var a = 0; a < activitiesData.data.length; a++) {
			activitiesContent += "<option value='" + activitiesData.data[a].activity + "'>" + activitiesData.data[a].activity + "</option>";
		}
		document.getElementById("newActivitySelect").innerHTML = activitiesContent;

		document.getElementById("imageloader2").style.display = "none";

	} else if(document.getElementById("settingselect").value == "Edit Template") {
		
		document.getElementById("generalsettings").style.display = "none";
		document.getElementById("filteredwordssettings").style.display = "none";
		document.getElementById("sharetemplatetogroup").style.display = "none";
		document.getElementById("sharetemplatetoindividual").style.display = "none";
		document.getElementById("addnewgroup").style.display = "none";
		document.getElementById("adddeletetopic").style.display = "none";
		document.getElementById("adddeleteactivity").style.display = "none";
		document.getElementById("addnewprompt").style.display = "none";
		document.getElementById("manageusers").style.display = "none";
		document.getElementById("editnewprompt").style.display = "block";

		document.getElementById("editPromptSeparateMultiRandom").style.display = "none";

		var topicsData = await getTopics();
		var activitiesData = await getActivities();
		var promptsToEditData = await getToEditPrompts();

		var promptsToEditOptionContent = "";
		promptsToEditOptionContent += "<option value=''>Select prompt template</option>";
		for(var sg = 0; sg < promptsToEditData.data.length; sg++) {
			promptsToEditOptionContent += "<option value=" + promptsToEditData.data[sg].id + ">" + promptsToEditData.data[sg].title + "</option>";
		}
		document.getElementById("edittemplates").innerHTML = promptsToEditOptionContent;

		var topicsContent = "";
		document.getElementById("editTopicSelect").innerHTML = "";
		topicsContent += "<option value=''>Select topic</option>";
		for(var t = 0; t < topicsData.data.length; t++) {
			topicsContent += "<option value='" + topicsData.data[t].topic + "'>" + topicsData.data[t].topic + "</option>";
		}
		document.getElementById("editTopicSelect").innerHTML = topicsContent;

		var activitiesContent = "";
		document.getElementById("editActivitySelect").innerHTML = "";
		activitiesContent += "<option value=''>Select activity</option>";
		for(var a = 0; a < activitiesData.data.length; a++) {
			activitiesContent += "<option value='" + activitiesData.data[a].activity + "'>" + activitiesData.data[a].activity + "</option>";
		}
		document.getElementById("editActivitySelect").innerHTML = activitiesContent;

		document.getElementById("edittemplates").onchange = async function() {
			//alert(document.getElementById("edittemplates").value);
			// const promptsCollection = cloudDB.collection('prompts');
			// const promptRef = promptsCollection.doc(document.getElementById("edittemplates").value);
			// const promptSnapshot = await promptRef.get();

			var promptSnapshot = await getSinglePrompt(document.getElementById("edittemplates").value);
			console.log(promptSnapshot);
			if (promptSnapshot.data.length > 0) {
			  // Access the document data using documentData variable
			  document.getElementById("editTitle").value = promptSnapshot.data[0].title;
			  document.getElementById("editTeaser").value = promptSnapshot.data[0].teaser;

			  if(promptSnapshot.data[0].type == "Multivariate Alchemy") {
			  	document.getElementById("editPromptSeparateMultiRandom").style.display = "block";
			  	document.getElementById("editPrompt").style.display = "none";

			  	var editPromptList = promptSnapshot.data[0].prompt.split("[===]");
			  	for(var mrp = 0; mrp < editPromptList.length; mrp++) {
							document.getElementsByClassName("editPromptMultiRandom")[mrp].value = editPromptList[mrp];
					}
			  } else {
			  	document.getElementById("editPromptSeparateMultiRandom").style.display = "none";
			  	document.getElementById("editPrompt").style.display = "block";

			  	document.getElementById("editPrompt").value = promptSnapshot.data[0].prompt;
			  }

			  document.getElementById("editPromptHint").value = promptSnapshot.data[0].prompthint;
			  document.getElementById("editAuthorName").value = promptSnapshot.data[0].authorname;
			  document.getElementById("editAuthorURL").value = promptSnapshot.data[0].authorurl;

			  for(var i = 0; i < document.getElementById("editPromptType").children.length; i++) {
			  	if(document.getElementById("editPromptType").children[i].innerText == promptSnapshot.data[0].type) {
			  		document.getElementById("editPromptType").children[i].setAttribute("selected", "selected")
			  	}
			  }

			  for(var j = 0; j < document.getElementById("editPublicitySelect").children.length; j++) {
			  	if(document.getElementById("editPublicitySelect").children[j].innerText == promptSnapshot.data[0].publicity) {
			  		document.getElementById("editPublicitySelect").children[j].setAttribute("selected", "selected")
			  	}
			  }

			  for(var k = 0; k < document.getElementById("editTopicSelect").children.length; k++) {
			  	if(document.getElementById("editTopicSelect").children[k].innerText == promptSnapshot.data[0].community) {
			  		document.getElementById("editTopicSelect").children[k].setAttribute("selected", "selected")
			  	}
			  }

			  for(var l = 0; l < document.getElementById("editActivitySelect").children.length; l++) {
			  	if(document.getElementById("editActivitySelect").children[l].innerText == promptSnapshot.data[0].category) {
			  		document.getElementById("editActivitySelect").children[l].setAttribute("selected", "selected")
			  	}
			  }

			  for(var m = 0; m < document.getElementById("editInstructionSelect").children.length; m++) {
			  	if(document.getElementById("editInstructionSelect").children[m].innerText == promptSnapshot.data[0].instructiontype) {
			  		document.getElementById("editInstructionSelect").children[m].setAttribute("selected", "selected")
			  	}
			  }

			  document.getElementById("editInstruction").value = promptSnapshot.data[0].instruction;
			  document.getElementById("editSocialWebsite").value = promptSnapshot.data[0].links;
			  document.getElementById("editPromptID").value = promptSnapshot.data[0].id;
			} else {
			  // Document does not exist
			  console.log("Document not found");
			}

		}

		document.getElementById("imageloader2").style.display = "none";

	}

	else if(document.getElementById("settingselect").value == "Manage Users") {
		
		document.getElementById("generalsettings").style.display = "none";
		document.getElementById("filteredwordssettings").style.display = "none";
		document.getElementById("sharetemplatetogroup").style.display = "none";
		document.getElementById("sharetemplatetoindividual").style.display = "none";
		document.getElementById("addnewgroup").style.display = "none";
		document.getElementById("adddeletetopic").style.display = "none";
		document.getElementById("adddeleteactivity").style.display = "none";
		document.getElementById("addnewprompt").style.display = "none";
		document.getElementById("manageusers").style.display = "block";
		document.getElementById("editnewprompt").style.display = "none";

		var usersData = await getUsers();

		var usersContent = "";
		for(var a = 0; a < usersData.data.length; a++) {
			var status = "";
			if(usersData.data[a].ispaused == "1") {
				status = "Paused";
			} else {
				status = "Active";
			}
			usersContent += "<tr><td><input type='checkbox' class='usercheckboxes' value='" + usersData.data[a].id + "'></td><td>" + usersData.data[a].fullname + "</td><td>" +usersData.data[a].email + "</td><td>" + status + "</td></tr>";
		}
		document.getElementById("userlistTbody").innerHTML = usersContent;

		document.getElementById("imageloader2").style.display = "none";

	}

}

chrome.storage.local.get(["extensiondisplaysettings", "digipromptsemail"], async function(result) {

	if(result.extensiondisplaysettings !== null) {
		if(result.extensiondisplaysettings == "on") {
			document.getElementById("extensiondisplaysettings").checked = true;
		} else {
			document.getElementById("extensiondisplaysettings").checked = false;
		}
	} else {
		document.getElementById("extensiondisplaysettings").checked = false;
	}

	document.getElementById("settingselect").innerHTML = "";
	// var currentUser = await getUser(result.digipromptsemail);

	var currentUser = await getSingleUser(result.digipromptsemail);
	console.log(currentUser);
	if(currentUser.data[0].isadmin == "1") {
		document.getElementById("viewmode").innerText = currentUser.data[0].fullname + " (" + currentUser.data[0].email + ") " + "Admin mode";
		document.getElementById("viewmode").style.backgroundColor = "green";
		document.getElementById("viewmode").style.borderRadius = "5px";
		document.getElementById("viewmode").style.padding = "10px";
		document.getElementById("viewmode").style.color = "white";
		document.getElementById("loadingview").style.display = "none";

		document.getElementById("settingselect").innerHTML = `
			<option value="General">General</option>
			<option value="Filtered Words">Filtered Words</option>
			<option value="Share Template To Group">Share Template To Group</option>
			<option value="Share Template To Individual">Share Template To Individual</option>
			<option value="Create New Group">Create New Group</option>
			<option value="Create New Template">Create New Template</option>
			<option value="Edit Template">Edit Template</option>
			<option value="Manage Topics">Manage Topics</option>
			<option value="Manage Activities">Manage Activities</option>
			<option value="Manage Users">Manage Users</option>
			<option value="Change Password">Change Password</option>
		`;
	} else {
		document.getElementById("viewmode").innerText = currentUser.data[0].fullname + " (" + currentUser.data[0].email + ") " + "Standard user mode";
		document.getElementById("viewmode").style.backgroundColor = "rgba(247,247,248,1)";
		document.getElementById("viewmode").style.borderRadius = "5px";
		document.getElementById("viewmode").style.padding = "10px";
		document.getElementById("loadingview").style.display = "none";

		document.getElementById("settingselect").innerHTML = `
			<option value="General">General</option>
			<option value="Share Template To Group">Share Template To Group</option>
			<option value="Share Template To Individual">Share Template To Individual</option>
			<option value="Change Password">Change Password</option>
		`;
	}

});

document.getElementById("savesettings").onclick = function() {
	if(document.getElementById("extensiondisplaysettings").checked == false) {
		chrome.storage.local.set({extensiondisplaysettings: "off"});
	} else {
		chrome.storage.local.set({extensiondisplaysettings: "on"});
	}
	alert("Settings successfully saved!");
}

if(localStorage.getItem("digiprompts_filteredwords") === null) {
	// const doc = await cloudDB.collection('filteredwords').get().then(snapshot => snapshot.docs.map(x => x.data()));
	// var objectFiltersItems = {"filteredwords": []};
	// for(var d = 0; d < doc.length; d++) {
	// 	objectFiltersItems.filteredwords.push({
	// 		"word": doc[d].word,
	// 	});
	// }
	var filteredwords = await getFilteredWords();
	var objectFiltersItems = {"filteredwords": []};
	for(var d = 0; d < filteredwords.data.length; d++) {
		objectFiltersItems.filteredwords.push({
			"word": filteredwords.data[d].word,
		});
	}
	localStorage.setItem("digiprompts_filteredwords", JSON.stringify(objectFiltersItems));

	var words = JSON.parse(localStorage.getItem("digiprompts_filteredwords"));

	var wordlist = "";
	for(var w = 0; w < words.filteredwords.length; w++) {
		wordlist += words.filteredwords[w].word + "\r\n";
	}
	document.getElementById("filteredwordslist").innerHTML = wordlist;
} else {
	var words = JSON.parse(localStorage.getItem("digiprompts_filteredwords"));

	var wordlist = "";
	for(var w = 0; w < words.filteredwords.length; w++) {
		wordlist += words.filteredwords[w].word + "\r\n";
	}
	document.getElementById("filteredwordslist").innerHTML = wordlist;
}

/*
if(localStorage.getItem("digiprompts_prompts") === null) {
	const doc = await cloudDB.collection('prompts').get().then(snapshot => snapshot.docs.map(x => x.data()));
	var objectFiltersItems = {"filteredwords": []};
	for(var d = 0; d < doc.length; d++) {
		objectFiltersItems.filteredwords.push({
			"word": doc[d].word,
		});
	}
	localStorage.setItem("digiprompts_filteredwords", JSON.stringify(objectFiltersItems));

	var words = JSON.parse(localStorage.getItem("digiprompts_filteredwords"));

	var wordlist = "";
	for(var w = 0; w < words.filteredwords.length; w++) {
		wordlist += words.filteredwords[w].word + "\r\n";
	}
	document.getElementById("filteredwordslist").innerHTML = wordlist;
} else {
	var words = JSON.parse(localStorage.getItem("digiprompts_filteredwords"));

	var wordlist = "";
	for(var w = 0; w < words.filteredwords.length; w++) {
		wordlist += words.filteredwords[w].word + "\r\n";
	}
	document.getElementById("filteredwordslist").innerHTML = wordlist;
}
*/

async function saveFilteredWords(data) {
    try {
        const response = await fetch(apiLink + '?action=save_filtered_words', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
            },
            body: JSON.stringify(data),
        });
        if (!response.ok) {
            throw new Error('Network response was not ok');
        }
        console.log(response);
        return await response.json();
    } catch (error) {
        console.error('Fetch operation failed:', error);
    }
}

async function saveGroupShare(data) {
    try {
        const response = await fetch(apiLink + '?action=save_group_share', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
            },
            body: JSON.stringify(data),
        });
        if (!response.ok) {
            throw new Error('Network response was not ok');
        }
        console.log(response);
        return await response.json();
    } catch (error) {
        console.error('Fetch operation failed:', error);
    }
}

async function saveIndividualShare(data) {
    try {
        const response = await fetch(apiLink + '?action=save_individual_share', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
            },
            body: JSON.stringify(data),
        });
        if (!response.ok) {
            throw new Error('Network response was not ok');
        }
        console.log(response);
        return await response.json();
    } catch (error) {
        console.error('Fetch operation failed:', error);
    }
}

document.getElementById("savefilteredwords").onclick = async function() {
	if(document.getElementById("filteredwords").value != "") {
		var filteredwords = document.getElementById("filteredwords").value;
		var filteredwordsarray = filteredwords.split(",");
		for(var f = 0; f < filteredwordsarray.length; f++) {
			// cloudDB.collection("filteredwords").add(
			// {
			// 		word: filteredwordsarray[f],
			// 		createdby: document.getElementById("useremailfromchrome").value
			// })
			// .then(function (docRef){})
			// .catch(function(error){ console.log(error); })
			var filteredWordsData = {
	      word: filteredwordsarray[f],
	      createdby: document.getElementById("useremailfromchrome").value,
	    };
	    var saveNow = await saveFilteredWords(filteredWordsData);
		}

		// const doc2 = await cloudDB.collection('filteredwords').get().then(snapshot => snapshot.docs.map(x => x.data()));
		var filteredwordsSaved = await getFilteredWords();
		var objectFiltersItems = {"filteredwords": []};
		for(var d = 0; d < filteredwordsSaved.data.length; d++) {
			objectFiltersItems.filteredwords.push({
				"word": filteredwordsSaved.data[d].word,
			});
		}
		localStorage.setItem("digiprompts_filteredwords", JSON.stringify(objectFiltersItems));

		var words = JSON.parse(localStorage.getItem("digiprompts_filteredwords"));

		var wordlist = "";
		for(var w = 0; w < words.filteredwords.length; w++) {
			wordlist += words.filteredwords[w].word + "\r\n";
		}
		document.getElementById("filteredwordslist").innerHTML = wordlist;

		alert("Words successfully saved!");
	} else {
		alert("No value detected!");
	}
}

document.getElementById("savesharetemplatetogroup").onclick = async function() {
	if(document.getElementById("grouplist").value != "" && document.getElementById("sharetogrouptemplates").value != "") {
		// const groupsCollection = cloudDB.collection('groupshare');
		// const groupsData = await groupsCollection.where('groupid', '==', document.getElementById("grouplist").value).where('templateid', '==', document.getElementById("sharetogrouptemplates").value).get().then(snapshot => {
		//   return snapshot.docs.map(doc => {
		//     return {
		// 	      id: doc.id,
		// 	      data: doc.data()
		//     };
		//   });
		// });
		var groupsData = await checkGroupShareExistBeforeSaving(document.getElementById("grouplist").value, document.getElementById("sharetogrouptemplates").value);

		if(groupsData.length == 0) {
			// cloudDB.collection("groupshare").add({
			// 		groupid: document.getElementById("grouplist").value,
			// 		templateid: document.getElementById("sharetogrouptemplates").value
			// })
			// .then(function (docRef) {
			// 	alert("Successfully shared the template to group!");
			// })
			// .catch(function(error){ console.log(error); });
			var groupShareData = {
	      group_id: filteredwordsarray[f],
	      template_id: document.getElementById("useremailfromchrome").value,
	    };
	    var saveNow = await saveGroupShare(groupShareData);
		} else {
			alert("Template already shared to group!");
		}
	} else {
		alert("Please complete the details!");
	}
}

document.getElementById("savesharetemplatetoindividual").onclick = async function() {
	if(document.getElementById("sharedindividuals").value != "" && document.getElementById("sharetoindividualtemplates").value != "") {
		var individualemailArray = document.getElementById("sharedindividuals").value.split(",");
		var successcounter = 0;

		for(var is = 0; is < individualemailArray.length; is++) {
			// const individualCollection = cloudDB.collection('individualshare');
			// const individualData = await individualCollection.where('templateid', '==', document.getElementById("sharetoindividualtemplates").value).where('useremail', '==', individualemailArray[is].trim()).get().then(snapshot => {
			//   return snapshot.docs.map(doc => {
			//     return {
			// 	      id: doc.id,
			// 	      data: doc.data()
			//     };
			//   });
			// });
			var individualData = chechIndividualShareExistBeforeSaving(individualemailArray[is].trim(), document.getElementById("sharetoindividualtemplates").value);

			if(individualData.data.length == 0) {
				// cloudDB.collection("individualshare").add({
				// 		useremail: individualemailArray[is].trim(),
				// 		templateid: document.getElementById("sharetoindividualtemplates").value,
				// 		createdby: document.getElementById("useremailfromchrome").value
				// })
				// .then(function (docRef) {
				// 	alert("Successfully shared the template to "+individualemailArray[is].trim()+"!");
				// })
				// .catch(function(error){ console.log(error); });
				var individualShareData = {
		      createdby: document.getElementById("useremailfromchrome").value,
		      templateid: document.getElementById("sharetoindividualtemplates").value,
		      useremail: individualemailArray[is].trim()
		    };
				var saveNow = await saveIndividualShare(individualShareData);
			} else {
				alert("Template already shared to "+individualemailArray[is].trim()+"!");
			}
		}
	} else {
		alert("Please complete the details!");
	}
}

document.getElementById("addtopic").onclick = async function() {
	document.getElementById("addtopic").disabled = true;
	if(document.getElementById("topic").value != "") {
		// const topicCollection = cloudDB.collection('topics');
		// const topicData = await topicCollection.where('topic', '==', document.getElementById("topic").value).get().then(snapshot => {
		//   return snapshot.docs.map(doc => {
		//     return {
		// 	      id: doc.id,
		// 	      data: doc.data()
		//     };
		//   });
		// });
		var topicCheckData = {
	    topic: document.getElementById("topic").value
	  };
		var topicData = await checkExistingTopics(topicCheckData);
		console.log(topicData);
		if(topicData.data.length == 0) {

			var topicSaveData = {
	      topic: document.getElementById("topic").value
	    };
			var saveNow = await saveTopic(topicSaveData);

			// cloudDB.collection("topics").add({
			// 		topic: document.getElementById("topic").value
			// })
			// .then(async function (docRef) {
				alert("Successfully saved the topic!");

				// const topicsCollection = cloudDB.collection('topics');
				// const topicsData = await topicsCollection.get().then(snapshot => {
				//   return snapshot.docs.map(doc => {
				//     return {
				// 	      id: doc.id,
				// 	      data: doc.data()
				//     };
				//   });
				// });
				var topicsData = await getTopics();
				var topicsContent = "";
				for(var t = 0; t < topicsData.data.length; t++) {
					topicsContent += "<tr><td><input type='checkbox' class='topiccheckboxes' value='" + topicsData.data[t].id + "'></td><td>" + topicsData.data[t].topic + "</td></tr>";
				}
				document.getElementById("topiclistTbody").innerHTML = topicsContent;
				document.getElementById("topic").value = "";
				document.getElementById("addtopic").disabled = false;

				chrome.tabs.query({active: true, currentWindow: true}, async (tabs) => {
					chrome.tabs.sendMessage(tabs[0].id, {
					    messageType: "RELOAD_CHATGPT",
					}, (response) => {       
					    console.log(response);
					});
				});
			
			// })
			// .catch(function(error){ console.log(error); });
		} else {
			alert("Topic already saved!");
			document.getElementById("topic").value = "";
			document.getElementById("addtopic").disabled = false;
		}
	} else {
		alert("Please complete the details!");
		document.getElementById("addtopic").disabled = false;
	}
}

document.getElementById("deletetopic").onclick = async function() {
	document.getElementById("deletetopic").disabled = true;
	for(var dt = 0; dt < document.getElementsByClassName("topiccheckboxes").length; dt++) {
		if(document.getElementsByClassName("topiccheckboxes")[dt].checked == true) {
			
			// cloudDB.collection("topics").doc(document.getElementsByClassName("topiccheckboxes")[dt].value).delete().then(() => {
			//     console.log("Document "+document.getElementsByClassName("topiccheckboxes")[dt].value+" successfully deleted!");
			// });
			var topicDeleteData = {
	      topicid: document.getElementsByClassName("topiccheckboxes")[dt].value
	    };
			var saveNow = await deleteTopic(topicDeleteData);

		}
	}
	alert("Successfully deleted selected topics!");
	// const topicsCollection = cloudDB.collection('topics');
	// const topicsData = await topicsCollection.get().then(snapshot => {
	//   return snapshot.docs.map(doc => {
	//     return {
	// 	      id: doc.id,
	// 	      data: doc.data()
	//     };
	//   });
	// });
	var topicsData = await getTopics();

	var topicsContent = "";
	for(var t = 0; t < topicsData.data.length; t++) {
		topicsContent += "<tr><td><input type='checkbox' class='topiccheckboxes' value='" + topicsData.data[t].id + "'></td><td>" + topicsData.data[t].topic + "</td></tr>";
	}
	document.getElementById("topiclistTbody").innerHTML = topicsContent;
	document.getElementById("deletetopic").disabled = false;
	
	chrome.tabs.query({active: true, currentWindow: true}, async (tabs) => {
		chrome.tabs.sendMessage(tabs[0].id, {
		    messageType: "RELOAD_CHATGPT",
		}, (response) => {       
		    console.log(response);
		});
	});

}

document.getElementById("addactivity").onclick = async function() {
	document.getElementById("addactivity").disabled = true;
	if(document.getElementById("activity").value != "") {
		// const activityCollection = cloudDB.collection('activities');
		// const activityData = await activityCollection.where('activity', '==', document.getElementById("activity").value).get().then(snapshot => {
		//   return snapshot.docs.map(doc => {
		//     return {
		// 	      id: doc.id,
		// 	      data: doc.data()
		//     };
		//   });
		// });
		var activityCheckData = {
	    activity: document.getElementById("activity").value
	  };
		var activityData = await checkExistingActivities(activityCheckData);
		console.log(activityData);
		if(activityData.data.length == 0) {

			var activitySaveData = {
				topic: document.getElementById("activitytopic").value,
	      activity: document.getElementById("activity").value
	    };
			var saveNow = await saveActivity(activitySaveData);
			
			// cloudDB.collection("activities").add({
			// 		activity: document.getElementById("activity").value
			// })
			// .then(async function (docRef) {
				alert("Successfully saved the activity!");

				// const activitiesCollection = cloudDB.collection('activities');
				// const activitiesData = await activitiesCollection.get().then(snapshot => {
				//   return snapshot.docs.map(doc => {
				//     return {
				// 	      id: doc.id,
				// 	      data: doc.data()
				//     };
				//   });
				// });

				var activitiesData = await getActivities();
				var activitiesContent = "";
				for(var a = 0; a < activitiesData.data.length; a++) {
					activitiesContent += "<tr><td><input type='checkbox' class='activitycheckboxes' value='" + activitiesData.data[a].id + "'></td><td>" + activitiesData.data[a].activity + "</td></tr>";
				}
				document.getElementById("activitylistTbody").innerHTML = activitiesContent;
				document.getElementById("activity").value = "";
				document.getElementById("addactivity").disabled = false;

				chrome.tabs.query({active: true, currentWindow: true}, async (tabs) => {
					chrome.tabs.sendMessage(tabs[0].id, {
					    messageType: "RELOAD_CHATGPT",
					}, (response) => {       
					    console.log(response);
					});
				});
			
			// })
			// .catch(function(error){ console.log(error); });
		} else {
			alert("Activity already saved!");
			document.getElementById("activity").value = "";
			document.getElementById("addactivity").disabled = false;
		}
	} else {
		alert("Please complete the details!");
		document.getElementById("addactivity").disabled = false;
	}
}

document.getElementById("deleteactivity").onclick = async function() {
	document.getElementById("deleteactivity").disabled = true;
	for(var dt = 0; dt < document.getElementsByClassName("activitycheckboxes").length; dt++) {
		if(document.getElementsByClassName("activitycheckboxes")[dt].checked == true) {
			
			// cloudDB.collection("activities").doc(document.getElementsByClassName("activitycheckboxes")[dt].value).delete().then(() => {
			//     console.log("Document "+document.getElementsByClassName("activitycheckboxes")[dt].value+" successfully deleted!");
			// });
			var activityDeleteData = {
	      activityid: document.getElementsByClassName("activitycheckboxes")[dt].value
	    };
			var deleteActivityNow = await deleteActivity(activityDeleteData);

		}
	}
	alert("Successfully deleted selected activities!");
	// const activitiesCollection = cloudDB.collection('activities');
	// const activitiesData = await activitiesCollection.get().then(snapshot => {
	//   return snapshot.docs.map(doc => {
	//     return {
	// 	      id: doc.id,
	// 	      data: doc.data()
	//     };
	//   });
	// });
	var activitiesData = await getActivities();
	var activitiesContent = "";
	for(var a = 0; a < activitiesData.data.length; a++) {
		activitiesContent += "<tr><td><input type='checkbox' class='activitycheckboxes' value='" + activitiesData.data[a].id + "'></td><td>" + activitiesData.data[a].activity + "</td></tr>";
	}
	document.getElementById("activitylistTbody").innerHTML = activitiesContent;
	document.getElementById("deleteactivity").disabled = false;
	
	chrome.tabs.query({active: true, currentWindow: true}, async (tabs) => {
		chrome.tabs.sendMessage(tabs[0].id, {
		    messageType: "RELOAD_CHATGPT",
		}, (response) => {       
		    console.log(response);
		});
	});

}

document.getElementById("saveaddnewgroup").onclick = async function() {
	document.getElementById("saveaddnewgroup").disabled = true;
	if(document.getElementById("newgroupname").value != "") {

			// cloudDB.collection("groups").add({
			// 		GroupName: document.getElementById("newgroupname").value,
			// 		createdby: document.getElementById("useremailfromchrome").value,
			// })
			// .then(async function (docRef) {
				var groupSaveData = {
		      groupname: document.getElementById("newgroupname").value,
					createdby: document.getElementById("useremailfromchrome").value,
		    };
				var saveGroupNow = await saveGroup(groupSaveData);

				var groupmembertext = document.getElementById("newgroupemails").value;
		    var groupmembers = groupmembertext.split(",");

		    // cloudDB.collection("groupmembers").add({
				// 		groupname: document.getElementById("newgroupname").value,
				// 		groupmemberemail: document.getElementById("useremailfromchrome").value,
				// })
				// .then(async function (docRef) {
				// });
				var groupMemberSaveData = {
		      groupname: document.getElementById("newgroupname").value,
					groupmemberemail: document.getElementById("useremailfromchrome").value,
		    };
				var saveGroupMemberNow = await saveGroupMember(groupMemberSaveData);
		    
		    for(var l = 0; l < groupmembers.length; l++) {
		      // cloudDB.collection("groupmembers").add({
					// 		group: document.getElementById("newgroupname").value,
					// 		groupmemberemail: groupmembers[l],
					// })
					// .then(async function (docRef) {
					// });
					if(groupmembers[l] != document.getElementById("useremailfromchrome").value) {
						var groupMemberSaveData = {
				      groupname: document.getElementById("newgroupname").value,
							groupmemberemail: groupmembers[l],
				    };
						var saveGroupMemberNow = await saveGroupMember(groupMemberSaveData);
					}
		    }

		    alert("Successfully saved group and group members.");
		    document.getElementById("saveaddnewgroup").disabled = false;
		    document.getElementById("newgroupname").value = "";
		    document.getElementById("newgroupemails").value = "";

		    chrome.tabs.query({active: true, currentWindow: true}, async (tabs) => {
					chrome.tabs.sendMessage(tabs[0].id, {
					    messageType: "RELOAD_CHATGPT",
					}, (response) => {       
					    console.log(response);
					});
				});

			// })
	} else {
		alert("Please complete the details!");
		document.getElementById("saveaddnewgroup").disabled = false;
	}
}

document.getElementById("newTitle").oninput = function() {
	localStorage.setItem("digiprompts_newtitle", document.getElementById("newTitle").value);
}

document.getElementById("newTeaser").oninput = function() {
	localStorage.setItem("digiprompts_newteaser", document.getElementById("newTeaser").value);
}

document.getElementById("newPrompt").oninput = function() {
	localStorage.setItem("digiprompts_newprompt", document.getElementById("newPrompt").value);
}

document.getElementsByClassName("newPromptMultiRandom")[0].oninput = function() {
	localStorage.setItem("digiprompts_newpromptmultirandom1", document.getElementsByClassName("newPromptMultiRandom")[0].value);
}

document.getElementsByClassName("newPromptMultiRandom")[1].oninput = function() {
	localStorage.setItem("digiprompts_newpromptmultirandom2", document.getElementsByClassName("newPromptMultiRandom")[1].value);
}

document.getElementsByClassName("newPromptMultiRandom")[2].onchange = function() {
	localStorage.setItem("digiprompts_newpromptmultirandom3", document.getElementsByClassName("newPromptMultiRandom")[2].value);
}

document.getElementsByClassName("newPromptMultiRandom")[3].oninput = function() {
	localStorage.setItem("digiprompts_newpromptmultirandom4", document.getElementsByClassName("newPromptMultiRandom")[3].value);
}

document.getElementsByClassName("newPromptMultiRandom")[4].oninput = function() {
	localStorage.setItem("digiprompts_newpromptmultirandom5", document.getElementsByClassName("newPromptMultiRandom")[4].value);
}

document.getElementsByClassName("newPromptMultiRandom")[5].oninput = function() {
	localStorage.setItem("digiprompts_newpromptmultirandom6", document.getElementsByClassName("newPromptMultiRandom")[5].value);
}

document.getElementsByClassName("newPromptMultiRandom")[6].oninput = function() {
	localStorage.setItem("digiprompts_newpromptmultirandom7", document.getElementsByClassName("newPromptMultiRandom")[6].value);
}

document.getElementsByClassName("newPromptMultiRandom")[7].onchange = function() {
	localStorage.setItem("digiprompts_newpromptmultirandom8", document.getElementsByClassName("newPromptMultiRandom")[7].value);
}

document.getElementsByClassName("newPromptMultiRandom")[8].oninput = function() {
	localStorage.setItem("digiprompts_newpromptmultirandom9", document.getElementsByClassName("newPromptMultiRandom")[8].value);
}

document.getElementsByClassName("newPromptMultiRandom")[9].oninput = function() {
	localStorage.setItem("digiprompts_newpromptmultirandom10", document.getElementsByClassName("newPromptMultiRandom")[9].value);
}

document.getElementById("newPromptHint").oninput = function() {
	localStorage.setItem("digiprompts_newprompthint", document.getElementById("newPromptHint").value);
}

document.getElementById("newAuthorName").oninput = function() {
	localStorage.setItem("digiprompts_newauthorname", document.getElementById("newAuthorName").value);
}

document.getElementById("newAuthorURL").onchange = function() {
	localStorage.setItem("digiprompts_newauthorurl", document.getElementById("newAuthorURL").value);
}

document.getElementById("newPublicitySelect").oninput = function() {
	localStorage.setItem("digiprompts_newpublicityselect", document.getElementById("newPublicitySelect").value);
}

document.getElementById("newTopicSelect").oninput = function() {
	localStorage.setItem("digiprompts_newtopicselect", document.getElementById("newTopicSelect").value);
}

document.getElementById("newActivitySelect").oninput = function() {
	localStorage.setItem("digiprompts_newactivityselect", document.getElementById("newActivitySelect").value);
}

document.getElementById("newInstructionSelect").oninput = function() {
	localStorage.setItem("digiprompts_newinstructionselect", document.getElementById("newInstructionSelect").value);
}

document.getElementById("newInstruction").onchange = function() {
	localStorage.setItem("digiprompts_newinstruction", document.getElementById("newInstruction").value);
}

document.getElementById("newSocialWebsite").oninput = function() {
	localStorage.setItem("digiprompts_newsocialwebsite", document.getElementById("newSocialWebsite").value);
}

document.getElementById("saveNewPrompts").onclick = async function() {
	
	if(localStorage.getItem("digiprompts_newtitle") !== null) {
		localStorage.removeItem("digiprompts_newtitle");
	}

	if(localStorage.getItem("digiprompts_newteaser") !== null) {
		localStorage.removeItem("digiprompts_newteaser");
	}

	if(localStorage.getItem("digiprompts_newprompttype") !== null) {
		localStorage.removeItem("digiprompts_newprompttype");
	}

	if(localStorage.getItem("digiprompts_newprompt") !== null) {
		localStorage.removeItem("digiprompts_newprompt");
	}

	if(localStorage.getItem("digiprompts_newpromptmultirandom1") !== null) {
		localStorage.removeItem("digiprompts_newpromptmultirandom1");
	}

	if(localStorage.getItem("digiprompts_newpromptmultirandom2") !== null) {
		localStorage.removeItem("digiprompts_newpromptmultirandom2");
	}

	if(localStorage.getItem("digiprompts_newpromptmultirandom3") !== null) {
		localStorage.removeItem("digiprompts_newpromptmultirandom3");
	}

	if(localStorage.getItem("digiprompts_newpromptmultirandom4") !== null) {
		localStorage.removeItem("digiprompts_newpromptmultirandom4");
	}

	if(localStorage.getItem("digiprompts_newpromptmultirandom5") !== null) {
		localStorage.removeItem("digiprompts_newpromptmultirandom5");
	}

	if(localStorage.getItem("digiprompts_newpromptmultirandom6") !== null) {
		localStorage.removeItem("digiprompts_newpromptmultirandom6");
	}

	if(localStorage.getItem("digiprompts_newpromptmultirandom7") !== null) {
		localStorage.removeItem("digiprompts_newpromptmultirandom7");
	}

	if(localStorage.getItem("digiprompts_newpromptmultirandom8") !== null) {
		localStorage.removeItem("digiprompts_newpromptmultirandom8");
	}

	if(localStorage.getItem("digiprompts_newpromptmultirandom9") !== null) {
		localStorage.removeItem("digiprompts_newpromptmultirandom9");
	}

	if(localStorage.getItem("digiprompts_newpromptmultirandom10") !== null) {
		localStorage.removeItem("digiprompts_newpromptmultirandom10");
	}

	if(localStorage.getItem("digiprompts_newprompthint") !== null) {
		localStorage.removeItem("digiprompts_newprompthint");
	}

	if(localStorage.getItem("digiprompts_newauthorname") !== null) {
		localStorage.removeItem("digiprompts_newauthorname");
	}

	if(localStorage.getItem("digiprompts_newauthorurl") !== null) {
		localStorage.removeItem("digiprompts_newauthorurl");
	}

	if(localStorage.getItem("digiprompts_newpublicityselect") !== null) {
		localStorage.removeItem("digiprompts_newpublicityselect");
	}

	if(localStorage.getItem("digiprompts_newtopicselect") !== null) {
		localStorage.removeItem("digiprompts_newtopicselect");
	}

	if(localStorage.getItem("digiprompts_newactivityselect") !== null) {
		localStorage.removeItem("digiprompts_newactivityselect");
	}

	if(localStorage.getItem("digiprompts_newinstructionselect") !== null) {
		localStorage.removeItem("digiprompts_newinstructionselect");
	}

	if(localStorage.getItem("digiprompts_newinstruction") !== null) {
		localStorage.removeItem("digiprompts_newinstruction");
	}

	if(localStorage.getItem("digiprompts_newsocialwebsite") !== null) {
		localStorage.removeItem("digiprompts_newsocialwebsite");
	}

	document.getElementById("saveNewPrompts").disabled = true;
	var newTitle = document.getElementById("newTitle").value;
	var newTeaser = document.getElementById("newTeaser").value;

	var newPrompt = "";
	if(document.getElementById("newPromptType").value == "Multivariate Alchemy") {
		let newPromptElements = document.getElementsByClassName("newPromptMultiRandom");
		for(var mrp = 0; mrp < document.getElementsByClassName("newPromptMultiRandom").length; mrp++) {
			if(document.getElementsByClassName("newPromptMultiRandom")[mrp].value != "") {
				newPrompt += document.getElementsByClassName("newPromptMultiRandom")[mrp].value + "[===]";
			}
		}
		newPrompt = newPrompt.replace(/\[===\](?=\s*$)/g, "");
	} else {
		newPrompt = document.getElementById("newPrompt").value;
	}

	var newPromptHint = document.getElementById("newPromptHint").value;
	var newAuthorName = document.getElementById("newAuthorName").value;
	var newAuthorURL = document.getElementById("newAuthorURL").value;
	var newPromptType = document.getElementById("newPromptType").value;
	var newPublicitySelect = document.getElementById("newPublicitySelect").value;
	var newTopicSelect = document.getElementById("newTopicSelect").value;
	var newActivitySelect = document.getElementById("newActivitySelect").value;
	var newInstruction = document.getElementById("newInstruction").value;
	var newInstructionSelect = document.getElementById("newInstructionSelect").value;
	var newSocialWebsite = document.getElementById("newSocialWebsite").value;
	const newDate = new Date();

	var formattedTextPrompt = newPrompt.replace(/\n/g, "<br>");

	var usersSaveData = {
	  authoremail: document.getElementById("useremailfromchrome").value,
		authorname: document.getElementById("newAuthorName").value,
		authorurl: document.getElementById("newAuthorURL").value,
		category: document.getElementById("newActivitySelect").value,
		community: document.getElementById("newTopicSelect").value,
		datepublished: newDate,
		prompt: formattedTextPrompt,
		prompthint: document.getElementById("newPromptHint").value,
		publicity: document.getElementById("newPublicitySelect").value,
		rejects: 0,
		teaser: document.getElementById("newTeaser").value,
		title: document.getElementById("newTitle").value,
		usages: 0,
		views: 0,
		votes: 0,
		instruction: document.getElementById("newInstruction").value,
		instructiontype: document.getElementById("newInstructionSelect").value,
		links: document.getElementById("newSocialWebsite").value,
		type: document.getElementById("newPromptType").value,
	};
	var savePromptNow = await savePrompt(usersSaveData);
	console.log(savePromptNow);
 	alert("Successfully added new prompt!");
	document.getElementById("saveNewPrompts").disabled = false;
	chrome.tabs.query({active: true, currentWindow: true}, async (tabs) => {
		chrome.tabs.sendMessage(tabs[0].id, {
		    messageType: "RELOAD_CHATGPT",
		}, (response) => {       
		    console.log(response);
		});
	});
	// location.reload();

	// cloudDB.collection("prompts").add({
	// 		AuthorEmail: document.getElementById("useremailfromchrome").value,
	// 		AuthorName: document.getElementById("newAuthorName").value,
	// 		AuthorURL: document.getElementById("newAuthorURL").value,
	// 		Category: document.getElementById("newActivitySelect").value,
	// 		Community: document.getElementById("newTopicSelect").value,
	// 		DatePublished: newDate,
	// 		Prompt: formattedTextPrompt,
	// 		PromptHint: document.getElementById("newPromptHint").value,
	// 		Publicity: document.getElementById("newPublicitySelect").value,
	// 		Rejects: 0,
	// 		Teaser: document.getElementById("newTeaser").value,
	// 		Title: document.getElementById("newTitle").value,
	// 		Usages: 0,
	// 		Views: 0,
	// 		Votes: 0,
	// 		instruction: document.getElementById("newInstruction").value,
	// 		instructiontype: document.getElementById("newInstructionSelect").value,
	// 		links: document.getElementById("newSocialWebsite").value,
	// 		type: document.getElementById("newPromptType").value,
	// })
	// .then(async function (docRef) {
	// 		alert("Successfully added new prompt!");
	// 		document.getElementById("saveNewPrompts").disabled = true;
	// 		chrome.tabs.query({active: true, currentWindow: true}, async (tabs) => {
	// 			chrome.tabs.sendMessage(tabs[0].id, {
	// 			    messageType: "RELOAD_CHATGPT",
	// 			}, (response) => {       
	// 			    console.log(response);
	// 			});
	// 		});
	// 		location.reload();
	// })
	// .catch(function(error){ console.log(error); });

}

document.getElementById("addmanageuser").onclick = async function() {
	document.getElementById("addmanageuser").disabled = true;
	if(document.getElementById("addname").value != "" && document.getElementById("addemail").value != "" && document.getElementById("addpassword").value != "") {
		// const topicCollection = cloudDB.collection('users');
		// const topicData = await topicCollection.where('email', '==', document.getElementById("addemail").value).get().then(snapshot => {
		//   return snapshot.docs.map(doc => {
		//     return {
		// 	      id: doc.id,
		// 	      data: doc.data()
		//     };
		//   });
		// });
		var checkUser = await getSingleUser(document.getElementById("addemail").value);

		if(checkUser.data.length == 0) {
			// cloudDB.collection("users").add({
			// 		email: document.getElementById("addemail").value,
			// 		fullname: document.getElementById("addname").value,
			// 		password: document.getElementById("addpassword").value,
			// 		isadmin: 0,
			// 		ispaused: 0
			// })
			// .then(async function (docRef) {
			var usersSaveData = {
		    email: document.getElementById("addemail").value,
		    fullname: document.getElementById("addname").value,
		    password: document.getElementById("addpassword").value,
		  };
			var saveUserNow = await saveUser(usersSaveData);

				alert("Successfully saved the user!");

				// const usersCollection = cloudDB.collection('users');
				// const usersData = await usersCollection.get().then(snapshot => {
				//   return snapshot.docs.map(doc => {
				//     return {
				// 	      id: doc.id,
				// 	      data: doc.data()
				//     };
				//   });
				// });
				var usersData = await getUsers();

				var usersContent = "";
				for(var a = 0; a < usersData.data.length; a++) {
					var status = "";
					if(usersData.data[a].ispaused == "1") {
						status = "Paused";
					} else {
						status = "Active";
					}
					usersContent += "<tr><td><input type='checkbox' class='usercheckboxes' value='" + usersData.data[a].id + "'></td><td>" + usersData.data[a].fullname + "</td><td>" + usersData.data[a].email + "</td><td>" + status + "</td></tr>";
				}
				document.getElementById("userlistTbody").innerHTML = usersContent;
				document.getElementById("addname").value = "";
				document.getElementById("addemail").value = "";
				document.getElementById("addpassword").value = "";
				document.getElementById("addmanageuser").disabled = false;

				chrome.tabs.query({active: true, currentWindow: true}, async (tabs) => {
					chrome.tabs.sendMessage(tabs[0].id, {
					    messageType: "RELOAD_CHATGPT",
					}, (response) => {       
					    console.log(response);
					});
				});
			
			// })
			// .catch(function(error){ console.log(error); });
		} else {
			alert("User already saved!");
			document.getElementById("addname").value = "";
			document.getElementById("addemail").value = "";
			document.getElementById("addpassword").value = "";
			document.getElementById("addmanageuser").disabled = false;
		}
	} else {
		alert("Please complete the details!");
		document.getElementById("addname").value = "";
		document.getElementById("addemail").value = "";
		document.getElementById("addpassword").value = "";
		document.getElementById("addmanageuser").disabled = false;
	}
}

document.getElementById("deletemanageuser").onclick = async function() {
	document.getElementById("deletemanageuser").disabled = true;
	for(var dt = 0; dt < document.getElementsByClassName("usercheckboxes").length; dt++) {
		if(document.getElementsByClassName("usercheckboxes")[dt].checked == true) {
			
			// cloudDB.collection("users").doc(document.getElementsByClassName("usercheckboxes")[dt].value).delete().then(() => {
			//     alert("Successfully deleted selected user!");
			// });
			var usersDeleteData = {
		    userid: document.getElementsByClassName("usercheckboxes")[dt].value
		  };
			var deleteUserNow = await deleteUser(usersDeleteData);

		}
	}
	
	var usersData = await getUsers();

	var usersContent = "";
	for(var a = 0; a < usersData.data.length; a++) {
		var status = "";
		if(usersData.data[a].ispaused == "1") {
			status = "Paused";
		} else {
			status = "Active";
		}
		usersContent += "<tr><td><input type='checkbox' class='usercheckboxes' value='" + usersData.data[a].id + "'></td><td>" + usersData.data[a].fullname + "</td><td>" + usersData.data[a].email + "</td><td>" + status + "</td></tr>";
	}
	document.getElementById("userlistTbody").innerHTML = usersContent;
	document.getElementById("deletemanageuser").disabled = false;

}

document.getElementById("pausemanageuser").onclick = async function() {
	document.getElementById("pausemanageuser").disabled = true;
	for(var dt = 0; dt < document.getElementsByClassName("usercheckboxes").length; dt++) {
		if(document.getElementsByClassName("usercheckboxes")[dt].checked == true) {
			
			// cloudDB.collection("users").doc(document.getElementsByClassName("usercheckboxes")[dt].value).update({
			//   ispaused: "1"
			// }).then(() => {
			//     alert("Successfully updated user status!");
			// });
			var usersPauseData = {
		    userid: document.getElementsByClassName("usercheckboxes")[dt].value
		  };
			var pauseUserNow = await pauseUser(usersPauseData);

		}
	}
	
	// const usersCollection = cloudDB.collection('users');
	// const usersData = await usersCollection.get().then(snapshot => {
	//   return snapshot.docs.map(doc => {
	//     return {
	// 	      id: doc.id,
	// 	      data: doc.data()
	//     };
	//   });
	// });
	var usersData = await getUsers();

	var usersContent = "";
	for(var a = 0; a < usersData.data.length; a++) {
		var status = "";
		if(usersData.data[a].ispaused == "1") {
			status = "Paused";
		} else {
			status = "Active";
		}
		usersContent += "<tr><td><input type='checkbox' class='usercheckboxes' value='" + usersData.data[a].id + "'></td><td>" + usersData.data[a].fullname + "</td><td>" + usersData.data[a].email + "</td><td>" + status + "</td></tr>";
	}
	document.getElementById("userlistTbody").innerHTML = usersContent;
	document.getElementById("pausemanageuser").disabled = false;

}

document.getElementById("activatemanageuser").onclick = async function() {
	document.getElementById("activatemanageuser").disabled = true;
	for(var dt = 0; dt < document.getElementsByClassName("usercheckboxes").length; dt++) {
		if(document.getElementsByClassName("usercheckboxes")[dt].checked == true) {
			
			// cloudDB.collection("users").doc(document.getElementsByClassName("usercheckboxes")[dt].value).update({
			//   ispaused: "0"
			// }).then(() => {
			//     alert("Successfully updated user status!");
			// });
			var usersActivateData = {
		    userid: document.getElementsByClassName("usercheckboxes")[dt].value
		  };
			var activateUserNow = await activateUser(usersActivateData);

		}
	}
	
	// const usersCollection = cloudDB.collection('users');
	// const usersData = await usersCollection.get().then(snapshot => {
	//   return snapshot.docs.map(doc => {
	//     return {
	// 	      id: doc.id,
	// 	      data: doc.data()
	//     };
	//   });
	// });
	var usersData = await getUsers();

	var usersContent = "";
	for(var a = 0; a < usersData.data.length; a++) {
		var status = "";
		if(usersData.data[a].ispaused == "1") {
			status = "Paused";
		} else {
			status = "Active";
		}
		usersContent += "<tr><td><input type='checkbox' class='usercheckboxes' value='" + usersData.data[a].id + "'></td><td>" + usersData.data[a].fullname + "</td><td>" + usersData.data[a].email + "</td><td>" + status + "</td></tr>";
	}
	document.getElementById("userlistTbody").innerHTML = usersContent;
	document.getElementById("activatemanageuser").disabled = false;
	
}

document.getElementById("saveEditPrompts").onclick = async function() {
	

	// cloudDB.collection("prompts").doc(editPromptID).update({
	// 	AuthorName : editAuthorName,
	// 	AuthorURL : editAuthorURL,
	// 	Category : editActivitySelect,
	// 	Community : editTopicSelect,
	// 	Prompt : editPrompt,
	// 	PromptHint : editPromptHint,
	// 	Publicity : editPublicitySelect,
	// 	Teaser : editTeaser,
	// 	Title : editTitle,
	// 	instruction : editInstruction,
	// 	instructiontype : editInstructionSelect,
	// 	links : editSocialWebsite,
	// 	type : editPromptType
	// }).then(() => {
	// 	alert("Successfully successfully updated the prompt!");
	// 	chrome.tabs.query({active: true, currentWindow: true}, async (tabs) => {
	// 		chrome.tabs.sendMessage(tabs[0].id, {
	// 		    messageType: "RELOAD_CHATGPT",
	// 		}, (response) => {       
	// 		    console.log(response);
	// 		});
	// 	});
	// 	location.reload();
	// }).catch((error) => {
  //   alert("Error updating prompt: ", error);                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 
  // });;

	var newEditPrompt = "";
	if(document.getElementById("editPromptType").value == "Multivariate Alchemy") {
		for(var mrp = 0; mrp < document.getElementsByClassName("editPromptMultiRandom").length; mrp++) {
			if(document.getElementsByClassName("editPromptMultiRandom")[mrp].value != "") {
				newEditPrompt += document.getElementsByClassName("editPromptMultiRandom")[mrp].value + " [===]";
			}
		}
		newEditPrompt = newEditPrompt.replace(/\[===\](?=\s*$)/g, "");
	} else {
		newEditPrompt = document.getElementById("editPrompt").value;	
	}

  var usersUpdateData = {
	  title: document.getElementById("editTitle").value,
		teaser: document.getElementById("editTeaser").value,
		prompt: newEditPrompt,
		prompthint: document.getElementById("editPromptHint").value,
		authorname: document.getElementById("editAuthorName").value,
		authorurl: document.getElementById("editAuthorURL").value,
		authoremail: document.getElementById("useremailfromchrome").value,
		type: document.getElementById("editPromptType").value,
	  publicity: document.getElementById("editPublicitySelect").value,
	  community: document.getElementById("editTopicSelect").value,
	  category: document.getElementById("editActivitySelect").value,
	  instructiontype: document.getElementById("editInstructionSelect").value,
		instruction: document.getElementById("editInstruction").value,
		links: document.getElementById("editSocialWebsite").value,
		id: document.getElementById("editPromptID").value
	};
	var savePromptNow = await updatePrompt(usersUpdateData);

	alert("Successfully successfully updated the prompt!");
		chrome.tabs.query({active: true, currentWindow: true}, async (tabs) => {
			chrome.tabs.sendMessage(tabs[0].id, {
			    messageType: "RELOAD_CHATGPT",
			}, (response) => {       
			    console.log(response);
			});
		});
		location.reload();
}

// async function getUser (dataemail)
// {
//   const doc = await cloudDB.collection('users').where('email', '==', dataemail).get().then(snapshot => snapshot.docs.map(x => x.data()));
//   return doc;
// };

	$('.select2').select2();

