var apiLink = "https://unicacloud.me/atomicgainsextension/data.php";
localStorage.setItem("digiprompts_claudesaving", "no");

function injectTemplatePromptHolder() {
	var th = document.getElementsByTagName('body')[0];
	var i = document.createElement('input');
	i.setAttribute('type', 'hidden');
	i.setAttribute('id', 'templatepromptholder');
	th.appendChild(i);
}
function injectTemplateTypePromptHolder() {
	var th = document.getElementsByTagName('body')[0];
	var i = document.createElement('input');
	i.setAttribute('type', 'hidden');
	i.setAttribute('id', 'templatetypepromptholder');
	th.appendChild(i);
}
injectTemplatePromptHolder();
injectTemplateTypePromptHolder();

chrome.runtime.onMessage.addListener((request, sender, sendResponse) => {
	  if(request.messageType == "CHECK_CLAUDE") {
	  	sendResponse(window.location.href);
	  } else if(request.messageType == "PROCEED_TO_CLAUDE") {
	  	sendResponse(window.location.href);
	  	localStorage.setItem("digiprompts_claudesaving", "no");
	  	window.location.href = "https://claude.ai/chats";
	  } else if(request.messageType == "EXECUTE_PROMPTS") {
	  	sendResponse(window.location.href);
	  	actionPrompt(request.promptId.split("-")[1]);
	  }
});

async function actionPrompt(promptId) {
		var singlePrompt = await getSinglePrompt(promptId);
		// console.log(singlePrompt.data[0].);
		var hints = singlePrompt.data[0].prompthint.split("[=]");
		var newhints = "";
		for(var h = 0; h < hints.length; h++) {
				newhints += "<p>"+hints[h]+": </p>";
		}
		document.getElementsByClassName("ProseMirror")[0].innerHTML = newhints;
		document.getElementById("templatepromptholder").value = singlePrompt.data[0].prompt;
		document.getElementById("templatetypepromptholder").value = singlePrompt.data[0].type;
		document.getElementsByClassName("mb-8")[0].innerText = document.getElementsByClassName("mb-8")[0].innerText + ", Atomic Gains prompting will work properly clicking the SEND button. Don't press Enter to send."
		document.getElementsByClassName("py-2")[0].style.border = "3px solid blue";
}

async function getSinglePrompt(template_id) {
    try {
        const response = await fetch(apiLink + '?action=get_single_prompt&id='+template_id);
        if (!response.ok) {
            throw new Error('Network response was not ok');
        }
        return await response.json(); // Return the processed data
    } catch (error) {
        console.error('Fetch operation failed:', error);
    }
}

async function getClaudeChat(chatid) {
    try {
        const response = await fetch(apiLink + '?action=get_claudechat&chatid='+chatid);
        if (!response.ok) {
            throw new Error('Network response was not ok');
        }
        return await response.json(); // Return the processed data
    } catch (error) {
        console.error('Fetch operation failed:', error);
    }
}

async function saveClaudeChat(data) {
    try {
        const response = await fetch(apiLink + '?action=save_claudechats', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
            },
            body: JSON.stringify(data),
        });
        if (!response.ok) {
            throw new Error('Network response was not ok');
        }
        console.log(response);
        return await response.json();
    } catch (error) {
        console.error('Fetch operation failed:', error);
    }
}

// var removecounter = 0;
// var checkerInterval = setInterval(async function() {
// 		if(window.location.href.includes("claude.ai/chat/")) {
// 				const url = window.location.href;
// 				const uuid = url.split("/").pop();
// 				var singlePrompt = await getClaudeChat(uuid);
// 		    if(singlePrompt.data.length > 0) {
// 		    		if(removecounter == 0) {
// 		    				localStorage.setItem("digiprompts_currentlydeletedprompt", document.getElementsByClassName("whitespace-pre-wrap break-words")[0].innerText);
// 		    				document.getElementsByClassName("whitespace-pre-wrap break-words")[0].remove();
// 		    		}
// 		        removecounter = removecounter + 1;
// 		    }
// 		} else {
// 				removecounter = 0;
// 		}
// }, 1000);

async function hideTemplate() {
	document.getElementsByClassName("whitespace-pre-wrap break-words")[0].innerText = "Loading...";
	if(window.location.href.includes("claude.ai/chat/")) {
		const url = window.location.href;
		const uuid = url.split("/").pop();
		var singlePrompt = await getClaudeChat(uuid);
	    if(singlePrompt.data.length > 0) {
	    	document.getElementsByClassName("whitespace-pre-wrap break-words")[0].innerText = singlePrompt.data[0].hint;
	    }
	}
}

if(window.location.href.includes("claude.ai/chats")) {
	document.getElementsByClassName("py-2")[0].onclick = function() {

		localStorage.setItem("digiprompts_claudehint", document.getElementsByClassName("ProseMirror")[0].innerText);
		localStorage.setItem("digiprompts_claudeisfromnew", "yes");
		saveClaudeChatData(document.getElementsByClassName("ProseMirror")[0].innerText);

		var parentDiv = document.getElementsByClassName("ProseMirror")[0];
		var newPTag = document.createElement("p");
		if(document.getElementById("templatetypepromptholder").value == "Multivariate Alchemy") {
			var randomPrompt = document.getElementById("templatepromptholder").value.split("[===]");
		        var finalprompt = "";
		        var randomInt = 0;
		        for(var mva = 0; mva < randomPrompt.length; mva++) {
		            var randomInt =GetRandomInt(0, (randomPrompt[mva].split("[=]").length-1)); 
	            	finalprompt += randomPrompt[mva].split("[=]")[randomInt]+"\n";
		        }
		        newPTag.innerHTML = "<p>"+finalprompt+"</p>";
			// var typeholdersplit = document.getElementById("templatepromptholder").value.split("[=]");
			// var randomInt = GetRandomInt(0, (typeholdersplit.length-1));
			// newPTag.innerHTML = "<p>"+typeholdersplit[randomInt]+"</p>";
		} else {
			newPTag.innerHTML = "<p>"+document.getElementById("templatepromptholder").value+"</p>";
		}
		parentDiv.insertBefore(newPTag, parentDiv.firstChild);

	}	

}

async function saveClaudeChatData(hint) {
	setTimeout(async function () {
      	var url2 = window.location.href;
		var uuid2 = url2.split("/").pop();
		var claudeData = {
			chatid: uuid2,
			hint: hint
		};
		var saveClaudeChatNow = await saveClaudeChat(claudeData);
		console.log(saveClaudeChatNow);
    }, 5000);
}

// document.getElementsByClassName("ProseMirror")[0].addEventListener('keydown', function(event) {
//     if (event.key === 'Enter') {
//         var parentDiv = document.getElementsByClassName("ProseMirror")[0];
// 				var newPTag = document.createElement("p");
// 				if(document.getElementById("templatetypepromptholder").value == "Multivariate Alchemy") {
// 						// var typeholdersplit = document.getElementById("templatepromptholder").value.split("[=]");
// 						// var randomInt = GetRandomInt(0, (typeholdersplit.length-1));
// 						// newPTag.innerHTML = "<p>"+typeholdersplit[randomInt]+"</p>";
// 						var randomPrompt = document.getElementById("templatepromptholder").value.split("[===]");
// 			            var finalprompt = "";
// 			            var randomInt = 0;
// 			            for(var mva = 0; mva < randomPrompt.length; mva++) {
// 			                var randomInt =GetRandomInt(0, randomPrompt[mva].split("[=]").length);
// 		                	finalprompt += randomPrompt[mva].split("[=]")[randomInt]+"\n\n";
// 			            }
// 			            newPTag.innerHTML = "<p>"+finalprompt+"</p>";
// 				} else {
// 						newPTag.innerHTML = "<p>"+document.getElementById("templatepromptholder").value+"</p>";
// 				}
// 				parentDiv.insertBefore(newPTag, parentDiv.firstChild);
//     }
// });

function GetRandomInt(min, max) {
  return Math.floor(Math.random() * (max - min + 1)) + min;
}

function createObserver() {
     const observer = new MutationObserver((mutations) => {
      mutations.forEach(async (mutation) => {
        if (mutation.type !== 'childList')
          if (mutation.addedNodes.length == 0)
            return;
        const node = mutation.addedNodes[0];
        if (!node || !node.querySelector) return;
        await handleElementAdded(node);
      });
    });
    observer.observe(document.body, { subtree: true, childList: true });
}

async function handleElementAdded(e) {
  	if(e.querySelector('p.whitespace-pre-wrap.break-words')) {
  		if(document.getElementById("templatepromptholder").value != "") {
  			if(localStorage.getItem("digiprompts_claudeisfromnew") != null) {
	  			document.getElementsByClassName("whitespace-pre-wrap break-words")[0].innerText = localStorage.getItem("digiprompts_claudehint");
	  			localStorage.removeItem("digiprompts_claudeisfromnew");
	  			localStorage.removeItem("digiprompts_claudehint");
	  		} else if(localStorage.getItem("digiprompts_claudeisfromnew") == null) {
	  			hideTemplate();
	  		}	
  		}
  	}
}

createObserver();