"use strict";

chrome.runtime.onInstalled.addListener(function (object) {
    //let externalUrl = "http://yoursite.com/";
    let internalUrl = chrome.runtime.getURL("thankyou.html");

    if (object.reason === chrome.runtime.OnInstalledReason.INSTALL) {
        chrome.tabs.create({ url: internalUrl }, function (tab) {
            console.log("New tab launched.");
        });
    }
});

/*
chrome.runtime.onInstalled.addListener(function (details) {
    if (details.reason === "install") {
        chrome.tabs.create({ url: "https://chat.openai.com/chat" })
    }
})
*/

chrome.action.onClicked.addListener(() => {
    chrome.tabs.query({url: "https://chat.openai.com/chat"}, function([ tab ]) {
        if (tab) {
        chrome.tabs.update(tab.id, {active: true})
        } else {
        chrome.tabs.create({url: "https://chat.openai.com/chat"})
        }
    })
})

//chrome.identity.getProfileUserInfo(function(userInfo) {
//   console.log(userInfo.email+" - "+userInfo.id);
//});


chrome.runtime.onMessage.addListener(function(request, sender, sendResponse){
    if(request.messageType == "GET_CHROME_USER_INFO") {
        chrome.identity.getProfileUserInfo(function(userInfo) {
           sendResponse(userInfo);
        });
    }
    return true;
});

chrome.tabs.onActivated.addListener(function(info) {
    //console.log("Tab changed!");
    chrome.tabs.query({ active: true, currentWindow: true }, function (tabs) {
      var currentUrl = tabs[0].url;
      chrome.storage.local.set({currentUrl: currentUrl});
    });
});

